<html>

<!--***************************************************************************
*
* Filename:     Write_File_Info.php
*
* Description:  An example file showing how a user can write the metadata of an
*               image over the internet in the same way that Photoshop
*               edits 'File Info' data.
*               This script pairs with Edit_File_Info_Example.php, receiving
*               and processing the data from the HTML form in that script
*
* Author:       Evan Hunter
*
* Date:         17/11/2004
*
* Project:      PHP JPEG Metadata Toolkit
*
* Revision:     1.11
*
* Changes:      1.10 -> 1.11 : Changed displayed toolkit version numbers to reference Toolkit_Version.php
*                              Changed error reporting to no errors
*                              Removed limitation on file being in current directory
*
* URL:          http://electronics.ozhiker.com
*
* Copyright:    Copyright Evan Hunter 2004
*
* License:      This file is part of the PHP JPEG Metadata Toolkit.
*
*               The PHP JPEG Metadata Toolkit is free software; you can
*               redistribute it and/or modify it under the terms of the
*               GNU General Public License as published by the Free Software
*               Foundation; either version 2 of the License, or (at your
*               option) any later version.
*
*               The PHP JPEG Metadata Toolkit is distributed in the hope
*               that it will be useful, but WITHOUT ANY WARRANTY; without
*               even the implied warranty of MERCHANTABILITY or FITNESS
*               FOR A PARTICULAR PURPOSE.  See the GNU General Public License
*               for more details.
*
*               You should have received a copy of the GNU General Public
*               License along with the PHP JPEG Metadata Toolkit; if not,
*               write to the Free Software Foundation, Inc., 59 Temple
*               Place, Suite 330, Boston, MA  02111-1307  USA
*
*               If you require a different license for commercial or other
*               purposes, please contact the author: evan@ozhiker.com
*
***************************************************************************-->


        <head>
                 <META HTTP-EQUIV="Content-Style-Type" CONTENT="text/css">
                <link rel='stylesheet' href='../application/ergonomie/style.css'>
               
                <title>Writing Photoshop File Info Metadata</title>
        </head>

        <body>
                <?php include 'Toolkit_Version.php'; ?>
                <br>
                <br>

                <?php
                        // Turn off Error Reporting
                        error_reporting ( 1 );          // Change: changed to no reporting -  as of version 1.11

                        include 'Toolkit_Version.php';  // Change: added as of version 1.11

                        // Include the required files for reading and writing Photoshop File Info
                        include 'JPEG.php';
                        include 'XMP.php';
                        include 'Photoshop_IRB.php';
                        include 'EXIF.php';
                        include 'Photoshop_File_Info.php';


                        // Copy all of the HTML Posted variables into an array
                        $new_ps_file_info_array = $GLOBALS['HTTP_POST_VARS'];

			//ajouter date
			$new_ps_file_info_array['date']= date("Y-m-d");

                        // Some characters are escaped with backslashes in HTML Posted variable
                        // Cycle through each of the HTML Posted variables, and strip out the slashes
                        foreach( $new_ps_file_info_array as $var_key => $var_val )
                        {
                                $new_ps_file_info_array[ $var_key ] = stripslashes( $var_val );
                        }

                        // Keywords should be an array - explode it on newline boundarys
                        $new_ps_file_info_array[ 'keywords' ] = explode( "\n", trim( $new_ps_file_info_array[ 'keywords' ] ) );

                        // Supplemental Categories should be an array - explode it on newline boundarys
                        $new_ps_file_info_array[ 'supplementalcategories' ] = explode( "\n", trim( $new_ps_file_info_array[ 'supplementalcategories' ] ) );

                        // Make the filename easier to access
                        $filename = $new_ps_file_info_array[ 'filename' ];

                        // Protect against hackers editing other files
                        $path_parts = pathinfo( $filename );
                        if ( strcasecmp( $path_parts["extension"], "jpg" ) != 0 )
                        {
                                echo "Incorrect File Type - JPEG Only\n";
                                exit( );
                        }
                        // Change: removed limitation on file being in current directory - as of version 1.11

                        // Retrieve the header information
                        $jpeg_header_data = get_jpeg_header_data( $filename );

                        // Retreive the EXIF, XMP and Photoshop IRB information from
                        // the existing file, so that it can be updated
                        $Exif_array = get_EXIF_JPEG( $filename );
                        $XMP_array = read_XMP_array_from_text( get_XMP_text( $jpeg_header_data ) );
                        $IRB_array = get_Photoshop_IRB( $jpeg_header_data );

                        // Update the JPEG header information with the new Photoshop File Info
                        $jpeg_header_data = put_photoshop_file_info( $jpeg_header_data, $new_ps_file_info_array, $Exif_array, $XMP_array, $IRB_array );

                        // Check if the Update worked
                        if ( $jpeg_header_data == FALSE )
                        {
                                // Update of file info didn't work - output error message
                                echo "Error - Failure update Photoshop File Info : $filename <br>\n";

                                // Output HTML with the form and data which was
                                // sent, to allow the user to fix it

                                $outputfilename = $filename;
                                //include "../application/markers.php";
                                echo "</body>\n";
                                echo "</html>\n";

                                // Abort processing
                                exit( );
                        }

                        // Attempt to write the new JPEG file
                        if ( FALSE == put_jpeg_header_data( $filename, $filename, $jpeg_header_data ) )
                        {
                                // Writing of the new file didn't work - output error message
                                echo "Error - Failure to write new JPEG : $filename <br>\n";

                                // Output HTML with the form and data which was
                                // sent, to allow the user to fix it

                                $outputfilename = $filename;
                               //include "../application/markers.php";
                                echo "</body>\n";
                                echo "</html>\n";

                                // Abort processing
                                exit( );
                        }


                ?>

                <br>
                <br>
                <br>
                <br>

                <br>
                <br>

        </body>

</html>